package h.com.serialapp.activity.fragment

import android.os.Bundle
import android.os.Handler
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.AdapterView
import android.widget.ArrayAdapter
import h.com.serialapp.R
import h.com.serialapp.adapter.LogAdapter
import h.com.serialportapi.comn.CommPacket
import h.com.serialportapi.comn.SerialReadThread
import h.com.serialportapi.comn.message.IMessage
import h.com.serialportapi.comn.message.LogManager
import kotlinx.android.synthetic.main.view_iso15693.view.*

/**
 * Created by hxd on 2018/10/21.
 */
class ISO15693 : BasesFragment(), AdapterView.OnItemSelectedListener {

    lateinit var views: View
    var logAdapter: LogAdapter = LogAdapter()
    lateinit var current: String

    override fun add(message: IMessage) {
        logAdapter.add(message)
        views.lv_log.setSelection(logAdapter.count - 1)
    }

    var handler = Handler(Handler.Callback { msg ->
        when (msg.what) {
            1 -> {
                views.et_uid_number.setText(current)
            }
            2 -> {
                views.et_readBlock.setText(current)
            }
        }
        false
    })

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View {
        var view = inflater!!.inflate(R.layout.view_iso15693, null)
        views = view
        view.lv_log.adapter = logAdapter
        views = view
        views.btn_clear_log.setOnClickListener {
            LogManager.instance().clear()
            logAdapter.notifyDataSetChanged()
        }
        bindView()
        return view
    }

    var flagValue: String = "0X22"
    var addValue: String = "0"
    lateinit var addArray: Array<String>
    lateinit var flag: Array<String>
    fun bindView() {
        addArray = resources.getStringArray(R.array.block_addr)
        flag = resources.getStringArray(R.array.flag)
        views.spinner_flag.adapter = ArrayAdapter<String>(activity, R.layout.spinner_default_item, flag)
        views.spinner_addr.adapter = ArrayAdapter<String>(activity, R.layout.spinner_default_item, addArray)
        views.spinner_flag.onItemSelectedListener = this
        views.spinner_addr.onItemSelectedListener = this
        views.bt_inventory.setOnClickListener {
            CommPacket.ISO15693_Inventory("26", SerialReadThread.ReaderListener { msg ->
                if (msg.length == 26) {
                    current = msg.substring(8, 24)
                    handler.sendEmptyMessage(1)
                }
            })
        }
        views.bt_selectCard.setOnClickListener { CommPacket.ISO15693_SelectCard(flagValue.substring(2, 4), views.et_uid_number.text.toString(), SerialReadThread.ReaderListener { }) }
        views.bt_stayQuiet.setOnClickListener { CommPacket.ISO15693_StayQuiet(flagValue.substring(2, 4), views.et_uid_number.text.toString(), SerialReadThread.ReaderListener { }) }
        views.bt_apduChannel.setOnClickListener { CommPacket.PiccTransfer(views.et_apdu.text.toString(), SerialReadThread.ReaderListener { }) }
        views.bt_readBlock.setOnClickListener {
            CommPacket.ISO15693_Read_Block(flagValue.substring(2, 4), addValue, views.et_uid_number.text.toString(), SerialReadThread.ReaderListener { msg ->
                if (msg.length == 22) {
                    current = msg.substring(12, 20)
                    handler.sendEmptyMessage(2)
                }
            })
        }
        views.bt_writeBlock.setOnClickListener { CommPacket.ISO15693_Write_Block(flagValue.substring(2, 4), addValue, views.et_uid_number.text.toString(), views.et_writeBlock.text.toString(), SerialReadThread.ReaderListener { }) }
        views.bt_lockBlock.setOnClickListener { CommPacket.ISO15693_Lock_Block(flagValue.substring(2, 4), addValue, views.et_uid_number.text.toString(), SerialReadThread.ReaderListener { }) }
        views.bt_writeAFI.setOnClickListener { CommPacket.ISO15693_Write_AFI(flagValue.substring(2, 4), views.et_afi.text.toString(), views.et_uid_number.text.toString(), SerialReadThread.ReaderListener { }) }
        views.bt_lockAFI.setOnClickListener { CommPacket.ISO15693_Lock_AFI(flagValue.substring(2, 4), views.et_uid_number.text.toString(), SerialReadThread.ReaderListener { }) }
        views.bt_writeDSFID.setOnClickListener { CommPacket.ISO15693_Write_DSFID(flagValue.substring(2, 4), views.et_dsfid.text.toString(), views.et_uid_number.text.toString(), SerialReadThread.ReaderListener { }) }
        views.bt_lockDSFID.setOnClickListener { CommPacket.ISO15693_Lock_DSFID(flagValue.substring(2, 4), views.et_uid_number.text.toString(), SerialReadThread.ReaderListener { }) };
        views.bt_getCardInfo.setOnClickListener { CommPacket.ISO15693_Get_SysInfor(flagValue.substring(2, 4), views.et_uid_number.text.toString(), SerialReadThread.ReaderListener { }) }
    }

    override fun onItemSelected(p0: AdapterView<*>?, p1: View?, p2: Int, p3: Long) {
        // Spinner 选择监听
        when (p0!!.id) {
            R.id.spinner_flag -> {
                flagValue = flag.get(p2)
            }
            R.id.spinner_addr -> {
                addValue = addArray.get(p2)
            }
        }
    }

    override fun onNothingSelected(p0: AdapterView<*>?) {
        TODO("not implemented") //To change body of created functions use File | Settings | File Templates.
    }

}